from typing import Dict, List, Tuple

from llm.llm_wrapper import LLMWrapper
from llm.auxiliary import Auxiliary
from utils.logger import Logger

from .base_attack import BaseAttack
from core.attack_manager import AttackManager

class PASS(BaseAttack):

    def __init__(
        self, 
        logger: Logger, 
        llm: LLMWrapper, 
        auxiliary: Auxiliary, 
        config: Dict = {}
    ):
        super().__init__(logger, llm, auxiliary, config)

        self.attack_manager = AttackManager(logger, llm, auxiliary, config)

    def generate_prompt(self, query, target=None, category=None):
        final_info = self.attack_manager.process_query(query, target, category)
        return final_info['cur_query']
    
    def attack(self, query, target=None, category=None):
        final_info = self.attack_manager.process_query(query, target, category)
        return {
            "original_query": query,
            "cur_query": final_info['cur_query'],
            "response": final_info['response'],
            "judge": {
                "success_status": final_info['success']
            }
        }